#include <stdio.h>
#include "print.h"

#define COMPRESS_FROM_OFFSET 0x6d

int read_file(FILE* f, u8** out_buf, size_t* out_size);

int main() {
  u8* I; size_t I_size;
  FILE* fr = fopen("mozek.com", "rb"); if (!fr) die("Can't open mozek.com");
  if (read_file(fr, &I, &I_size)) return -1;
  fclose(fr);

  u8 C[4096] = {0}; size_t C_size = 0;  // commands
  u8 D[4096] = {0}; size_t D_size = 0;  // data

  int num_events[16] = {0};

  for (int i=COMPRESS_FROM_OFFSET; i<I_size; i++) {
    if (I[i]==0x0f && i+1<I_size) {
      C[C_size++] = 0;  // 0x0f, literal
      num_events[0]++;
      i++;
    }
    else {
      C[C_size++] = 1;  // literal
      num_events[1]++;
    }
    D[D_size++] = I[i];
  }

  // part 1: compressed
  FILE* f1 = fopen("mozek1.pak", "wb"); if (!f1) die("Can't create mozek1.pak");
  fwrite(D, 1, D_size, f1);
  fclose(f1);

  // part 2: compressed
  FILE* f2 = fopen("mozek2.bit", "wb"); if (!f2) die("Can't create mozek2.bit");
  u8 bits[4096/8] = {0}; size_t bits_size = (C_size+7)/8;
  for (int i=0; i<C_size; i++) {
    int bit = bits_size*8 - 1 - i;
    bits[bit>>3] |= C[i] << (bit&7);
  }
  fwrite(bits, 1, bits_size, f2);
  fclose(f2);

  // part 3: not compressed
  FILE* f3 = fopen("mozek3.raw", "wb"); if (!f3) die("Can't create mozek3.raw");
  fwrite(I, 1, COMPRESS_FROM_OFFSET, f3);
  fclose(f3);
  
  // print stats
  int BITS_START = D_size + bits_size - 32;  // cx=255

  print("; '0F xx' * ", num_events[0], ": ", num_events[0]*2, " -> ", num_events[0]*9/8., " bytes");
  print(";    'xx' * ", num_events[1], ": ", num_events[1]*1, " -> ", num_events[1]*9/8., " bytes");
  
  // print init and unpacker code
  print("org 0x100");

  print("  call COMPRESSED_SKIP");
  print("COMPRESSED_DATA:");
  print("incbin \"mozek1.pak\"");
  print("incbin \"mozek2.bit\"");
  print("%define BITS_START COMPRESSED_DATA+",BITS_START);  // +3 = size of "call"
  print("COMPRESSED_SKIP:");
  print("  pop si");
  print("  mov di,UNPACKED");
  print("  mov al,0x0f");
  print("UNPACK:");
  print("  bt [BITS_START],cx");
  print("  jc USKIP");
  print("  stosb");
  print("USKIP:");
  print("  movsb");
  print("  loop UNPACK");
  print("incbin \"mozek3.raw\"");
  print("UNPACKED:");

  return 0;
}


// Read the whole file into a newly allocated buffer.
// If the return value is 0:
// - out_buf contains the file with an appended '\0' byte,
// - out_size (optional) is the number of bytes read.
int read_file(FILE* f, u8** out_buf, size_t* out_size) {
  u8 *buf=0, *tmp;
  size_t done=0, read;

  if (!f || !out_buf) goto error;
  if (ferror(f)) goto error;

  for (size_t cap=0x10000; cap>done; cap *= 2) {
    tmp = (u8*)realloc(buf, cap);
    if (!tmp) goto error;
    buf = tmp;

    read = fread(buf+done, 1, cap-done, f);
    done += read;
    if (read == 0) break;
  }

  if (ferror(f)) goto error;

  tmp = (u8*)realloc(buf, done+1);
  if (!tmp) goto error;
  buf = tmp;

  buf[done] = '\0';

  *out_buf = buf;
  if (out_size) { *out_size = done; }
  return 0;

error:
  if (buf) { free(buf); }
  return -1;
}